
<?php $__env->startSection('title', 'تیکت ها'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">تیکت ها</li>
                    </ol>
                </div>
                <h4 class="page-title">تیکت ها</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <button type="button" class="btn btn-bordered-light text-muted waves-effect waves-light" data-target="#AdvancedFilterSection" data-toggle="collapse" aria-expanded="<?php echo e($hasFilter ?? 'false'); ?>"><i class="fa fa-filter mr-1"></i>فیلتر پیشرفته</button>
                    <?php if((auth()->user()->isStaff() and config('can_staff_create_ticket')) or auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('panel.tickets.create')); ?>" class="btn btn-primary waves-effect waves-light float-right mb-3"><i class="mdi mdi-comment-plus-outline mr-2"></i>ارسال تیکت جدید</a>
                    <?php endif; ?>
                </div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <div id="AdvancedFilterSection" class="collapse <?php if($hasFilter ?? false): ?> show <?php endif; ?>">
                    <form action="<?php echo e(route('panel.tickets.index')); ?>" method="get" role="form" class="mb-3">
                        <input type="hidden" id="fromDate" name="fdate" value="<?php echo e(request()->query('fdate' , '')); ?>">
                        <input type="hidden" id="toDate" name="tdate" value="<?php echo e(request()->query('tdate', '')); ?>">
                        <input type="hidden" id="filter" name="filter" value="1">
                        <div class="row">
                            <div class="col-sm-3">
                                <input type="text" class="form-control from-date-inp mb-1" name="from-date" value="<?php echo e(request()->query('from-date', '')); ?>" readonly placeholder="از ابتدای تاریخ">
                                <span class="clear-date" data-field="#fromDate"><i class="fa fa-times"></i></span>
                                <div class="from-date"></div>
                            </div>
                            <div class="col-sm-3">
                                <input type="text" class="form-control to-date-inp mb-1" name="to-date" value="<?php echo e(request()->query('to-date', '')); ?>" readonly placeholder="تا پایان تاریخ">
                                <span class="clear-date" data-field="#toDate"><i class="fa fa-times"></i></span>
                                <div class="to-date"></div>
                            </div>
                            <div class="col-sm-6">
                                <div class="row no-gutters">
                                    <div class="col-sm-8 pr-1">
                                        <input type="text" class="form-control mb-1" name="subject" value="<?php echo e(request()->query('subject', '')); ?>" placeholder="موضوع تیکت را وارد کنید"/>
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control mb-1" name="trackId" value="<?php echo e(request()->query('trackId', '')); ?>" placeholder="کد پیگیری را وارد کنید"/>
                                    </div>
                                </div>
                                <?php if(auth()->user()->isAdmin()): ?>
                                <?php if($users): ?>
                                <select name="users[]"
                                        dir="rtl"
                                        class="form-control select2-ajax mb-1"
                                        data-ajax-url="<?php echo e(route('panel.users.search')); ?>"
                                        data-placeholder="نام کاربران را جستجو و انتخاب کنید"
                                        data-allow-clear="true"
                                        multiple>
                                </select>
                                <?php else: ?>
                                <select name="users[]" class="form-control">
                                    <option value="0" disabled selected>کاربری یافت نشد</option>
                                </select>
                                <?php endif; ?>
                                <select name="departments[]" class="selectpicker my-1" multiple data-live-search="true" data-title="دپارتمان ها را انتخاب کنید" data-live-search-placeholder="نام دپارتمان را جستجو کنید...">
                                    <?php $__empty_1 = true; $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option value="<?php echo e($department->id); ?>" <?php if(in_array($department->id, request()->query('departments', []))): ?> selected <?php endif; ?>><?php echo e($department->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <option value="0" disabled>دپارتمانی یافت نشد</option>
                                    <?php endif; ?>
                                </select>
                                <?php endif; ?>
                                <select name="priorities[]" class="selectpicker mb-1" multiple data-title="اولویت ها را انتخاب کنید">
                                    <option value="1" <?php if(in_array('1', request()->query('priorities', []))): ?> selected <?php endif; ?>>کم اهمیت</option>
                                    <option value="2" <?php if(in_array('2', request()->query('priorities', []))): ?> selected <?php endif; ?>>متوسط</option>
                                    <option value="3" <?php if(in_array('3', request()->query('priorities', []))): ?> selected <?php endif; ?>>ضروری</option>
                                    <option value="4" <?php if(in_array('4', request()->query('priorities', []))): ?> selected <?php endif; ?>>بحرانی</option>
                                </select>
                                <div class="row align-items-center mb-2">
                                    <div class="col-sm-6">
                                        <select name="statuses[]" class="selectpicker mb-2" multiple data-title="وضعیت ها را انتخاب ید">
                                            <option value="unread" <?php if(in_array('unread', request()->query('statuses', []))): ?> selected <?php endif; ?>>خوانده نشده</option>
                                            <option value="read" <?php if(in_array('read', request()->query('statuses', []))): ?> selected <?php endif; ?>>خوانده شده</option>
                                            <option value="replied" <?php if(in_array('replied', request()->query('statuses', []))): ?> selected <?php endif; ?>>پاسخ داده شده</option>
                                            <option value="replied_pv" <?php if(in_array('replied_pv', request()->query('statuses', []))): ?> selected <?php endif; ?>>پاسخ محرمانه</option>
                                            <option value="referred" <?php if(in_array('referred', request()->query('statuses', []))): ?> selected <?php endif; ?>>ارجاع داده شده</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="custom-control custom-radio custom-control-inline pl-2">
                                            <input type="radio" id="OpenTickets" name="openCloseStatus" class="custom-control-input" value="open" <?php if(request()->openCloseStatus == 'open'): ?> checked <?php endif; ?>/>
                                            <label class="custom-control-label" for="OpenTickets">باز</label>
                                        </div>
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input type="radio" id="ClosedTickets" name="openCloseStatus" class="custom-control-input" value="close" <?php if(request()->openCloseStatus == 'close'): ?> checked <?php endif; ?>/>
                                            <label class="custom-control-label" for="ClosedTickets">بسته</label>
                                        </div>
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input type="radio" id="OpenAndClosedTickets" name="openCloseStatus" class="custom-control-input" value="both" <?php if(request()->openCloseStatus == 'both' or !request()->has('openCloseStatus')): ?> checked <?php endif; ?>/>
                                            <label class="custom-control-label" for="OpenAndClosedTickets">همه</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <select name="perPageCount" class="custom-select custom-select-sm" style="width:auto" id="PerPageCount">
                                        <option value="0" <?php if(!request()->has('perPageCount')): ?> selected <?php endif; ?> disabled>تعداد نتایج</option>
                                        <option value="10" <?php if(request()->perPageCount == '10'): ?> selected <?php endif; ?>>10 تا</option>
                                        <option value="25" <?php if(request()->perPageCount == '25'): ?> selected <?php endif; ?>>25 تا</option>
                                        <option value="50" <?php if(request()->perPageCount == '50'): ?> selected <?php endif; ?>>50 تا</option>
                                        <option value="100" <?php if(request()->perPageCount == '100'): ?> selected <?php endif; ?>>100 تا</option>
                                        <option value="200" <?php if(request()->perPageCount == '200'): ?> selected <?php endif; ?>>200 تا</option>
                                        <option value="500" <?php if(request()->perPageCount == '500'): ?> selected <?php endif; ?>>500 تا</option>
                                    </select>
                                    <select name="orderBy" class="custom-select custom-select-sm" style="width:auto" id="OrderBy">
                                        <option value="0" <?php if(!request()->has('orderBy')): ?> selected <?php endif; ?> disabled>مرتب سازی بر اساس</option>
                                        <option value="updated_at" <?php if(request()->orderBy == 'updated_at'): ?> selected <?php endif; ?>>آخرین تغییر</option>
                                        <option value="created_at" <?php if(request()->orderBy == 'created_at'): ?> selected <?php endif; ?>>تاریخ ایجاد</option>
                                        <option value="priority" <?php if(request()->orderBy == 'priority'): ?> selected <?php endif; ?>>اولویت</option>
                                        <option value="closed_at" <?php if(request()->orderBy == 'closed_at'): ?> selected <?php endif; ?>>بسته بودن</option>
                                        <option value="none" <?php if(request()->order == 'none'): ?> selected <?php endif; ?>>هیچکدام</option>
                                    </select>
                                    <select name="order" class="custom-select custom-select-sm" style="width:auto" id="Order">
                                        <option value="0" <?php if(!request()->has('order')): ?> selected <?php endif; ?> disabled>صعودی/نرولی</option>
                                        <option value="asc" <?php if(request()->order == 'asc'): ?> selected <?php endif; ?>>صعودی</option>
                                        <option value="desc" <?php if(request()->order == 'desc'): ?> selected <?php endif; ?>>نزولی</option>
                                        <option value="none" <?php if(request()->order == 'none'): ?> selected <?php endif; ?>>هیچکدام</option>
                                    </select>
                                </div>
                                <div class="clearfix">
                                    <button type="submit" class="btn btn-outline-primary float-right">نمایش نتایج</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <?php if($hasFilter ?? false): ?>
                        <div class="alert alert-info" id="resultsCount">
                            تعداد نتایج یافت شده: <?php echo e($tickets->total()); ?> تا
                        </div>
                    <?php endif; ?>
                </div>
                <div class="w-50 mb-3 mx-auto text-center">
                    <span class="badge badge-warning active" data-filter-status="unread">خوانده نشده</span>
                    <span class="badge badge-light active" data-filter-status="read">خوانده شده</span>
                    <span class="badge badge-primary active" data-filter-status="replied">پاسخ داده شده</span>
                    <span class="badge badge-purple active" data-filter-status="replied_pv">پاسخ محرمانه</span>
                    <span class="badge badge-dark active" data-filter-status="referred">ارجاع داده شده</span>
                    <span class="badge badge-danger active" data-filter-status="closed">بسته</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered text-center table-centered">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>اولویت</th>
                            <th>دپارتمان</th>
                            <th>کاربر</th>
                            <th>تاریخ</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-status="<?php echo e($ticket->status); ?>" data-is-closed="<?php echo e($ticket->isClosed()); ?>">
                                <td class="<?php if(!$ticket->isClosed()): ?> <?php echo e(ticket_status_color($ticket->status)); ?> <?php else: ?> table-danger <?php endif; ?>"><?php echo e($ticket->id); ?></td>
                                <td><a href="<?php echo e(route('panel.tickets.show', $ticket)); ?>" <?php if($ticket->isUnread()): ?> class="font-weight-bold" <?php endif; ?>><?php echo e($ticket->subject); ?></a></td>
                                <td><?php echo ticket_priority_label($ticket->priority); ?></td>
                                <td><?php echo e($ticket->department->name); ?></td>
                                <td><?php echo e($ticket->user->name); ?></td>
                                <td title="<?php echo jdate($ticket->created_at)->format('H:i:s Y/m/d'); ?>" data-toggle="tooltip"><?php echo jdate($ticket->created_at)->ago(); ?></td>
                                <td>
                                    <div class="btn-group dropdown">
                                        <a href="javascript: void(0);" class="dropdown-toggle arrow-none btn btn-light btn-sm" data-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-dots-horizontal"></i></a>
                                        <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(39px, 29px, 0px);">
                                            <?php if(!$ticket->isClosed()): ?>
                                                <?php if($ticket->isRead()): ?>
                                                    <a class="dropdown-item" href="#" data-mark-as-unread="<?php echo e(route('panel.tickets.markAsUnread', $ticket)); ?>">تغییر به خوانده نشده<i class="mdi mdi-message-alert-outline mr-2 text-muted font-18 align-middle"></i></a>
                                                <?php endif; ?>
                                                <a class="dropdown-item" href="#" data-close-ticket="<?php echo e(route('panel.tickets.close', $ticket)); ?>">بستن تیکت<i class="mdi mdi-minus-circle-outline mr-2 text-muted font-18 align-middle"></i></a>
                                            <?php else: ?>
                                                <a class="dropdown-item" href="#" data-reopen-ticket="<?php echo e(route('panel.tickets.reopen', $ticket)); ?>">بازگشایی تیکت<i class="remixicon-chat-check-line mr-2 text-muted font-18 align-middle"></i></a>
                                            <?php endif; ?>
                                            <a class="dropdown-item" href="#" data-delete-url="<?php echo e(route('panel.tickets.destroy', $ticket)); ?>">حذف تیکت<i class="mdi mdi-close-outline mr-2 font-18 text-muted align-middle"></i></a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="7" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($tickets->appends(request()->except('page'))->links()); ?>

            </div>
        </div><!-- end col -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-bottom'); ?>
    <?php if($hasFilter ?? false): ?>
        <script>
            $(document).ready(function(){
                $('body, html').animate({
                    scrollTop: $('#resultsCount').offset().top - 90
                }, 1200)
            });
        </script>
        <?php if(request()->filled('fdate')): ?>
        <script>
            $(document).ready(function(){
                from.setDate(<?php echo e(request()->fdate); ?>);
            });
        </script>
        <?php endif; ?>
        <?php if(request()->filled('tdate')): ?>
            <script>
                $(document).ready(function(){
                    to.setDate(<?php echo e(request()->tdate); ?>);
                });
            </script>
        <?php endif; ?>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/tickets/list.blade.php ENDPATH**/ ?>