
<?php $__env->startSection('title', 'تنظیمات پیامک'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('panel.settings.general')); ?>">تنظیمات</a></li>
                        <li class="breadcrumb-item active">پیامک</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات پیامک</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box" style="overflow: hidden">
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <form action="<?php echo e(route('panel.settings.sms.update')); ?>" class="form-horizontal" method="post" role="form">
                    <?php echo method_field('patch'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="smsUsername">سامانه پیامکی</label>
                        <div class="col-sm-10">
                            <select name="sms_settings[driver]" id="smsDriver" class="custom-select">
                                <option disabled <?php echo e(!in_array($activeDriver, array_keys($smsDrivers)) ? 'selected' : ''); ?>>
                                    سامانه پیامکی را انتخاب کنید
                                </option>
                                <?php $__currentLoopData = $smsDrivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver => $driverOptions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($driver); ?>" <?php echo e($activeDriver == $driver ? 'selected' : ''); ?>><?php echo e($driverOptions['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div id="smsDriverSettings" class="bg-light p-3">
                        <?php echo $__env->make($driverSettingsPath, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="border-top pt-2 border-light text-center">
                        <button class="btn btn-primary" type="submit">ذخیره</button>
                    </div>
                </form>
                <hr class="border-light"/>
                <h5 class="card-title">ارسال آزمایشی</h5>
                <form action="<?php echo e(route('panel.sms.sendTest')); ?>" role="form" id="sendTestSmsForm">
                    <div class="input-group">
                        <input type="text" class="form-control" id="mobile" placeholder="شماره موبایل" aria-label="شماره موبایل">
                        <div class="input-group-append">
                            <button class="btn btn-secondary waves-effect waves-light" type="submit">ارسال پیامک
                                آزمایشی
                            </button>
                        </div>
                    </div>
                    <small class="form-text text-muted">ارسال آزمایشی به صورت عادی ارسال خواهد شد و نه ارسال با
                        پترن.بنابراین پیش از ارسال آزمایشی می‌بایستی نام کاربری،کلمه‌عبور و شماره را تکمیل کنید</small>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-bottom'); ?>

    <script>
        function copyTextToClipboard(text) {
            var textArea = document.createElement("textarea");
            textArea.value = text
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                var successful = document.execCommand('copy');
                var msg = successful ? 'successful' : 'unsuccessful';

            } catch (err) {
                console.log('Oops, unable to copy');
            }

            document.body.removeChild(textArea);
        }

        $(document).ready(function () {
            $('body').on('change', '#usePatterns', function () {
                if ($(this).prop('checked') === false) {
                    $('#patternsSection').slideUp();
                    $('#smsNumber').removeAttr('readonly');
                } else {
                    $('#patternsSection').slideDown();
                    $('#smsNumber').attr('readonly', 'readonly');
                }
            });


            $('#smsDriver').change(function () {
                $('#smsDriverSettings').css('opacity', '0.4')
                let driver = $(this).val()
                $.get("<?php echo e(route('panel.settings.sms.loadSettings')); ?>", {driver: driver}, function (res) {
                    $('#smsDriverSettings').css('opacity', 1).html(res)
                })
            })

        }); // doc ready
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/settings/sms.blade.php ENDPATH**/ ?>