
<?php $__env->startSection('title', 'گزارشات کاربران'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">گزارشات کاربران</li>
                    </ol>
                </div>
                <h4 class="page-title">گزارشات کاربران</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">لیست گزارشات کاربران</h4>
                        <p class="sub-header">لیست گزارشاتی که کاربران و پشتیبانان از تیکت ها و پاسخ ها ارسال کرده اند</p>
                    </div>
                </div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>تیکت</th>
                            <th>کاربر</th>
                            <th>پشتیبان</th>
                            <th>وضعیت</th>
                            <th>تاریخ</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($report->id); ?></td>
                                <td><a href="<?php echo e(route('panel.tickets.show', $report->ticket)); ?>" target="_blank"><?php echo e($report->ticket->subject); ?></a></td>
                                <td><a href="<?php echo e(route('panel.users.show', $report->user)); ?>" target="_blank"><?php echo e($report->user->name); ?></a></td>
                                <td><?php echo e($report->reply->user->name ?? ' - '); ?></td>
                                <td><?php echo $report->isRead() ? '<span class="badge badge-light-primary">مشاهده شده</span>': '<span class="badge badge-light-warning">مشاهده نشده</span>'; ?></td>
                                <td title="<?php echo jdate($report->created_at)->format('H:i:s Y/m/d'); ?>"><?php echo jdate($report->created_at)->ago(); ?></td>
                                <td><a href="<?php echo e(route('panel.reports.show', $report)); ?>">مشاهده</a></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="7" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($reports->links()); ?>

            </div>
        </div><!-- end col -->
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/reports/list.blade.php ENDPATH**/ ?>