@extends('layouts.setup.master')

@section('content')
<div class="container mt-5">
    <div class="card">
        <div class="card-body">
            <div class="text-center mb-1 float-right">
                <a href="https://patronic.ir" class="text-muted" target="_blank">
                    <img src="{{ asset('assets/images/patronic-logo-dark.png') }}" alt="سیستم پشتیبانی و ارسال تیکت پاترونیک" class="mb-1" height="35">
                    <p>www.patronic.ir</p>
                </a>
            </div>
            <h3 class="card-title">مرحله سوم نصب - اطلاعات پایگاه داده</h3>
            <p class="card-subtitle">دریافت اطلاعات پایگاه داده</p>
            <hr>
            <div class="row">

                @include('layouts.setup.vertical-tabs')

                <div class="col-9">
                    <div class="tab-content pt-0" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-database-data" role="tabpanel" aria-labelledby="v-pills-database-data-tab">
                            @error('databaseError')
                            <div class="alert alert-danger"><strong>خطا! </strong>{{ $message }}</div>
                            @enderror
                            <form action="{{ route('setup.handle', ['step' => 3]) }}" method="post">
                                @csrf
                                <div class="form-group">
                                    <label for="DatabaseServer">نام و یا آدرس ip سرور پایگاه داده</label>
                                    <input type="text" class="form-control @error('databaseServer') is-invalid @enderror" id="DatabaseServer" name="databaseServer" value="{{ old('databaseServer') ?: 'localhost' }}" placeholder="مثال: localhost or 127.0.0.1" required>
                                    @error('databaseServer')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="DatabasePort">پورت پایگاه داده</label>
                                    <input type="text" class="form-control @error('databasePort') is-invalid @enderror" id="DatabasePort" name="databasePort" value="{{ old('databasePort') ?: '3306' }}" placeholder="مثال: 3306" required>
                                    @error('databasePort')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="DatabaseName">نام پایگاه داده</label>
                                    <input type="text" class="form-control @error('databaseName') is-invalid @enderror" id="DatabaseName" name="databaseName" value="{{ old('databaseName') }}" placeholder="مثال: patronic_database" required>
                                    @error('databaseName')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="DatabaseUsername">نام کاربری پایگاه داده</label>
                                    <input type="text" class="form-control @error('databaseUsername') is-invalid @enderror" id="DatabaseUsername" value="{{ old('databaseUsername') }}" name="databaseUsername" placeholder="مثال: patronic_database" required>
                                    @error('databaseUsername')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="DatabasePassword">کلمه عبور پایگاه داده</label>
                                    <input type="password" class="form-control @error('databasePassword') is-invalid @enderror" id="DatabasePassword" name="databasePassword" placeholder="کلمه عبور پایگاه داده را وارد کنید">
                                    @error('databasePassword')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group clearfix">
                                    <button type="submit" class="btn btn-primary float-right">مرحله بعد</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection