@extends('layouts.master')
@section('title', 'تیکت ها')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">تیکت ها</li>
                    </ol>
                </div>
                <h4 class="page-title">تیکت ها</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <button type="button" class="btn btn-bordered-light text-muted waves-effect waves-light" data-target="#AdvancedFilterSection" data-toggle="collapse" aria-expanded="{{ $hasFilter ?? 'false' }}"><i class="fa fa-filter mr-1"></i>فیلتر پیشرفته</button>
                    @if((auth()->user()->isStaff() and config('can_staff_create_ticket')) or auth()->user()->isAdmin())
                        <a href="{{ route('panel.tickets.create') }}" class="btn btn-primary waves-effect waves-light float-right mb-3"><i class="mdi mdi-comment-plus-outline mr-2"></i>ارسال تیکت جدید</a>
                    @endif
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div id="AdvancedFilterSection" class="collapse @if($hasFilter ?? false) show @endif">
                    <form action="{{ route('panel.tickets.index') }}" method="get" role="form" class="mb-3">
                        <input type="hidden" id="fromDate" name="fdate" value="{{ request()->query('fdate' , '') }}">
                        <input type="hidden" id="toDate" name="tdate" value="{{ request()->query('tdate', '') }}">
                        <input type="hidden" id="filter" name="filter" value="1">
                        <div class="row">
                            <div class="col-sm-3">
                                <input type="text" class="form-control from-date-inp mb-1" name="from-date" value="{{ request()->query('from-date', '') }}" readonly placeholder="از ابتدای تاریخ">
                                <span class="clear-date" data-field="#fromDate"><i class="fa fa-times"></i></span>
                                <div class="from-date"></div>
                            </div>
                            <div class="col-sm-3">
                                <input type="text" class="form-control to-date-inp mb-1" name="to-date" value="{{ request()->query('to-date', '') }}" readonly placeholder="تا پایان تاریخ">
                                <span class="clear-date" data-field="#toDate"><i class="fa fa-times"></i></span>
                                <div class="to-date"></div>
                            </div>
                            <div class="col-sm-6">
                                <div class="row no-gutters">
                                    <div class="col-sm-8 pr-1">
                                        <input type="text" class="form-control mb-1" name="subject" value="{{ request()->query('subject', '') }}" placeholder="موضوع تیکت را وارد کنید"/>
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control mb-1" name="trackId" value="{{ request()->query('trackId', '') }}" placeholder="کد پیگیری را وارد کنید"/>
                                    </div>
                                </div>
                                @if(auth()->user()->isAdmin())
                                @if($users)
                                <select name="users[]"
                                        dir="rtl"
                                        class="form-control select2-ajax mb-1"
                                        data-ajax-url="{{ route('panel.users.search') }}"
                                        data-placeholder="نام کاربران را جستجو و انتخاب کنید"
                                        data-allow-clear="true"
                                        multiple>
                                </select>
                                @else
                                <select name="users[]" class="form-control">
                                    <option value="0" disabled selected>کاربری یافت نشد</option>
                                </select>
                                @endif
                                <select name="departments[]" class="selectpicker my-1" multiple data-live-search="true" data-title="دپارتمان ها را انتخاب کنید" data-live-search-placeholder="نام دپارتمان را جستجو کنید...">
                                    @forelse($departments as $department)
                                        <option value="{{ $department->id }}" @if(in_array($department->id, request()->query('departments', []))) selected @endif>{{ $department->name }}</option>
                                    @empty
                                        <option value="0" disabled>دپارتمانی یافت نشد</option>
                                    @endforelse
                                </select>
                                @endif
                                <select name="priorities[]" class="selectpicker mb-1" multiple data-title="اولویت ها را انتخاب کنید">
                                    <option value="1" @if(in_array('1', request()->query('priorities', []))) selected @endif>کم اهمیت</option>
                                    <option value="2" @if(in_array('2', request()->query('priorities', []))) selected @endif>متوسط</option>
                                    <option value="3" @if(in_array('3', request()->query('priorities', []))) selected @endif>ضروری</option>
                                    <option value="4" @if(in_array('4', request()->query('priorities', []))) selected @endif>بحرانی</option>
                                </select>
                                <div class="row align-items-center mb-2">
                                    <div class="col-sm-6">
                                        <select name="statuses[]" class="selectpicker mb-2" multiple data-title="وضعیت ها را انتخاب ید">
                                            <option value="unread" @if(in_array('unread', request()->query('statuses', []))) selected @endif>خوانده نشده</option>
                                            <option value="read" @if(in_array('read', request()->query('statuses', []))) selected @endif>خوانده شده</option>
                                            <option value="replied" @if(in_array('replied', request()->query('statuses', []))) selected @endif>پاسخ داده شده</option>
                                            <option value="replied_pv" @if(in_array('replied_pv', request()->query('statuses', []))) selected @endif>پاسخ محرمانه</option>
                                            <option value="referred" @if(in_array('referred', request()->query('statuses', []))) selected @endif>ارجاع داده شده</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="custom-control custom-radio custom-control-inline pl-2">
                                            <input type="radio" id="OpenTickets" name="openCloseStatus" class="custom-control-input" value="open" @if(request()->openCloseStatus == 'open') checked @endif/>
                                            <label class="custom-control-label" for="OpenTickets">باز</label>
                                        </div>
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input type="radio" id="ClosedTickets" name="openCloseStatus" class="custom-control-input" value="close" @if(request()->openCloseStatus == 'close') checked @endif/>
                                            <label class="custom-control-label" for="ClosedTickets">بسته</label>
                                        </div>
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input type="radio" id="OpenAndClosedTickets" name="openCloseStatus" class="custom-control-input" value="both" @if(request()->openCloseStatus == 'both' or !request()->has('openCloseStatus')) checked @endif/>
                                            <label class="custom-control-label" for="OpenAndClosedTickets">همه</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <select name="perPageCount" class="custom-select custom-select-sm" style="width:auto" id="PerPageCount">
                                        <option value="0" @if(!request()->has('perPageCount')) selected @endif disabled>تعداد نتایج</option>
                                        <option value="10" @if(request()->perPageCount == '10') selected @endif>10 تا</option>
                                        <option value="25" @if(request()->perPageCount == '25') selected @endif>25 تا</option>
                                        <option value="50" @if(request()->perPageCount == '50') selected @endif>50 تا</option>
                                        <option value="100" @if(request()->perPageCount == '100') selected @endif>100 تا</option>
                                        <option value="200" @if(request()->perPageCount == '200') selected @endif>200 تا</option>
                                        <option value="500" @if(request()->perPageCount == '500') selected @endif>500 تا</option>
                                    </select>
                                    <select name="orderBy" class="custom-select custom-select-sm" style="width:auto" id="OrderBy">
                                        <option value="0" @if(!request()->has('orderBy')) selected @endif disabled>مرتب سازی بر اساس</option>
                                        <option value="updated_at" @if(request()->orderBy == 'updated_at') selected @endif>آخرین تغییر</option>
                                        <option value="created_at" @if(request()->orderBy == 'created_at') selected @endif>تاریخ ایجاد</option>
                                        <option value="priority" @if(request()->orderBy == 'priority') selected @endif>اولویت</option>
                                        <option value="closed_at" @if(request()->orderBy == 'closed_at') selected @endif>بسته بودن</option>
                                        <option value="none" @if(request()->order == 'none') selected @endif>هیچکدام</option>
                                    </select>
                                    <select name="order" class="custom-select custom-select-sm" style="width:auto" id="Order">
                                        <option value="0" @if(!request()->has('order')) selected @endif disabled>صعودی/نرولی</option>
                                        <option value="asc" @if(request()->order == 'asc') selected @endif>صعودی</option>
                                        <option value="desc" @if(request()->order == 'desc') selected @endif>نزولی</option>
                                        <option value="none" @if(request()->order == 'none') selected @endif>هیچکدام</option>
                                    </select>
                                </div>
                                <div class="clearfix">
                                    <button type="submit" class="btn btn-outline-primary float-right">نمایش نتایج</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    @if($hasFilter ?? false)
                        <div class="alert alert-info" id="resultsCount">
                            تعداد نتایج یافت شده: {{ $tickets->total() }} تا
                        </div>
                    @endif
                </div>
                <div class="w-50 mb-3 mx-auto text-center">
                    <span class="badge badge-warning active" data-filter-status="unread">خوانده نشده</span>
                    <span class="badge badge-light active" data-filter-status="read">خوانده شده</span>
                    <span class="badge badge-primary active" data-filter-status="replied">پاسخ داده شده</span>
                    <span class="badge badge-purple active" data-filter-status="replied_pv">پاسخ محرمانه</span>
                    <span class="badge badge-dark active" data-filter-status="referred">ارجاع داده شده</span>
                    <span class="badge badge-danger active" data-filter-status="closed">بسته</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered text-center table-centered">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>اولویت</th>
                            <th>دپارتمان</th>
                            <th>کاربر</th>
                            <th>تاریخ</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($tickets as $ticket)
                            <tr data-status="{{ $ticket->status }}" data-is-closed="{{ $ticket->isClosed() }}">
                                <td class="@if(!$ticket->isClosed()) {{ ticket_status_color($ticket->status) }} @else table-danger @endif">{{ $ticket->id }}</td>
                                <td><a href="{{ route('panel.tickets.show', $ticket) }}" @if($ticket->isUnread()) class="font-weight-bold" @endif>{{ $ticket->subject }}</a></td>
                                <td>{!! ticket_priority_label($ticket->priority) !!}</td>
                                <td>{{ $ticket->department->name }}</td>
                                <td>{{ $ticket->user->name }}</td>
                                <td title="@jalali($ticket->created_at)" data-toggle="tooltip">@jalali($ticket->created_at,true)</td>
                                <td>
                                    <div class="btn-group dropdown">
                                        <a href="javascript: void(0);" class="dropdown-toggle arrow-none btn btn-light btn-sm" data-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-dots-horizontal"></i></a>
                                        <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(39px, 29px, 0px);">
                                            @if(!$ticket->isClosed())
                                                @if($ticket->isRead())
                                                    <a class="dropdown-item" href="#" data-mark-as-unread="{{ route('panel.tickets.markAsUnread', $ticket) }}">تغییر به خوانده نشده<i class="mdi mdi-message-alert-outline mr-2 text-muted font-18 align-middle"></i></a>
                                                @endif
                                                <a class="dropdown-item" href="#" data-close-ticket="{{ route('panel.tickets.close', $ticket) }}">بستن تیکت<i class="mdi mdi-minus-circle-outline mr-2 text-muted font-18 align-middle"></i></a>
                                            @else
                                                <a class="dropdown-item" href="#" data-reopen-ticket="{{ route('panel.tickets.reopen', $ticket) }}">بازگشایی تیکت<i class="remixicon-chat-check-line mr-2 text-muted font-18 align-middle"></i></a>
                                            @endif
                                            <a class="dropdown-item" href="#" data-delete-url="{{ route('panel.tickets.destroy', $ticket) }}">حذف تیکت<i class="mdi mdi-close-outline mr-2 font-18 text-muted align-middle"></i></a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <td colspan="7" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $tickets->appends(request()->except('page'))->links() }}
            </div>
        </div><!-- end col -->
    </div>

@endsection

@push('script-bottom')
    @if($hasFilter ?? false)
        <script>
            $(document).ready(function(){
                $('body, html').animate({
                    scrollTop: $('#resultsCount').offset().top - 90
                }, 1200)
            });
        </script>
        @if(request()->filled('fdate'))
        <script>
            $(document).ready(function(){
                from.setDate({{ request()->fdate }});
            });
        </script>
        @endif
        @if(request()->filled('tdate'))
            <script>
                $(document).ready(function(){
                    to.setDate({{ request()->tdate }});
                });
            </script>
        @endif
    @endif
@endpush
