@extends('layouts.master')
@section('title', 'افزودن پشتیبان جدید')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.staffs.index') }}">پشتیبانان</a></li>
                        <li class="breadcrumb-item active">افزودن پشتیبان</li>
                    </ol>
                </div>
                <h4 class="page-title">افزودن پشتیبان جدید</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات پشتیبان</h4>
                </div>
                <form action="{{ route('panel.staffs.store') }}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="name" class="form-label">نام و نام خانوادگی</label>
                                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" id="name" placeholder="نام و نام خانوادگی را وارد کنید" value="{{ old('name') }}" required/>
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="email" class="form-label">ایمیل</label>
                                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" id="email" placeholder="مثال: email@site.com" value="{{ old('email') }}" required/>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="mobile" class="form-label">شماره موبایل</label>
                                    <input type="text" name="mobile" class="form-control @error('mobile') is-invalid @enderror" id="mobile" placeholder="مثال: 09123456789" title="شماره تماس 11 رقمی مانند: 09123456789" pattern="09\d{9}" value="{{ old('mobile') }}" required/>
                                    @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="username" class="col-form-label">نام کاربری</label>
                                    <input type="text" size="20" maxlength="20" id="username" name="username" class="form-control @error('username') is-invalid @enderror" placeholder="مثال : ali_22">
                                    @error('username')
                                    <div class="invalid-feedback">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @else
                                        <small class="form-text text-muted">حداکثر میتوانید 20 کارکتر وارد کنید.کارکترهای مجاز: حروف،اعداد،-،ـ </small>
                                        @enderror
                                </div>
                                <div class="form-group">
                                    <label for="StaffDepartments">دپارتمان</label>
                                    <select id="StaffDepartments" dir="rtl" name="departments[]" class="selectpicker" multiple data-selected-text-format="count > 3" data-live-search="true">
                                        @forelse($departments as $department)
                                            <option value="{{ $department->id }}">{{ $department->name }}</option>
                                        @empty
                                            <option value="0" disabled>دپارتمانی یافت نشد</option>
                                        @endforelse
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="password" class="form-label">کلمه عبور</label>
                                    <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="password" placeholder="کلمه عبور را وارد کنید" title="حداقل 8 رقم" min="8" required/>
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="active" name="status" value="active" checked>
                                        <label class="custom-control-label" for="active">فعال باشد</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" name="needVerification" value="true" id="needsVerification">
                                        <label class="custom-control-label" for="needsVerification">نیاز به تایید اطلاعات</label>
                                        <span class="remixicon-question-fill" data-toggle="tooltip" title="در صورت فعال بود این گزینه کاربر میبایست شماره همراه و ایمیل خود را تایید کند(باتوجه به تنظیمات)"></span>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection