@extends('layouts.master')
@section('title', 'تنظیمات ایمیل')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.settings.general') }}">تنظیمات</a></li>
                        <li class="breadcrumb-item active">ایمیل</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات ایمیل</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col">
            <div class="card-box">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <form action="{{ route('panel.settings.email.update') }}" class="form-horizontal" method="post" role="form">
                    @method('patch')
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="mailHost">هاست</label>
                        <div class="col-sm-10">
                            <input type="text" name="mail_host" class="form-control @error('mail_host') is-invalid @enderror" id="mailHost" placeholder="آدرس هاست SMTP مانند: localhost یا 192.168.23.24" value="{{ $settings['mail_host'] }}"/>
                            @error('mail_host')
                            <div class="invalid-feedback">
                                <small>{{ $message }}</small>
                            </div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="mailUsername">نام کاربری</label>
                        <div class="col-sm-10">
                            <input type="text" name="mail_username" class="form-control @error('mail_username') is-invalid @enderror" id="mailUsername" placeholder="نام کاربری اکانت SMTP در هاست مانند: mail@site.com" value="{{ $settings['mail_username'] }}"/>
                            @error('mail_username')
                            <div class="invalid-feedback">
                                <small>{{ $message }}</small>
                            </div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="mailPassword">کلمه عبور</label>
                        <div class="col-sm-10">
                            <input type="password" name="mail_password" class="form-control @error('mail_password') is-invalid @enderror" id="mailPassword" value="{{ $settings['mail_password'] }}" placeholder="کلمه عبور اکانت SMTP در هاست"/>
                            @error('mail_password')
                            <div class="invalid-feedback">
                                <small>{{ $message }}</small>
                            </div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="mailPort">پورت</label>
                        <div class="col-sm-10">
                            <input type="text" name="mail_port" class="form-control @error('mail_port') is-invalid @enderror" id="mailPort" value="{{ $settings['mail_port'] }}" placeholder="پورت اکانت SMTP در هاست مانند: 25 یا 478"/>
                            @error('mail_port')
                            <div class="invalid-feedback">
                                <small>{{ $message }}</small>
                            </div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="mailEncryption">رمزگذاری</label>
                        <div class="col-sm-10">
                            <input type="text" name="mail_encryption" class="form-control @error('mail_encryption') is-invalid @enderror" id="mailEncryption" value="{{ $settings['mail_encryption'] }}" placeholder="مثال: tls یا ssl"/>
                            @error('mail_encryption')
                            <div class="invalid-feedback">
                                <small>{{ $message }}</small>
                            </div>
                            @else
                                <small class="form-text text-muted">در صورت عدم تکمیل این کادر اطلاعات بدون رمزگذاری رد و بدل خواهند شد</small>
                            @enderror
                        </div>
                    </div>
                    <div class="clearfix border-top pt-2 border-light">
                        <button class="btn btn-primary float-right" type="submit">ذخیره</button>
                    </div>
                </form>
                <hr class="border-light"/>
                <h5 class="card-title">ارسال آزمایشی</h5>
                <form action="{{ route('panel.email.sendTest') }}" method="get" role="form" id="sendTestEmailForm">
                    <div class="input-group">
                        <input type="email" class="form-control" id="email" placeholder="ایمیل" aria-label="ایمیل">
                        <div class="input-group-append">
                            <button class="btn btn-secondary waves-effect waves-light" type="submit">ارسال ایمیل آزمایشی</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection