@extends('layouts.master')
@section('title', 'ویرایش دپارتمان')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.departments.index') }}">دپارتمان ها</a></li>
                        <li class="breadcrumb-item active">ویرایش دپارتمان</li>
                    </ol>
                </div>
                <h4 class="page-title">ویرایش دپارتمان</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات دپارتمان</h4>
                </div>
                <form action="{{ route('panel.departments.update', $department) }}" method="post">
                    @csrf
                    @method('patch')
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="departmentName">عنوان دپارتمان</label>
                                    <input type="text" name="departmentName" class="form-control @error('departmentName') is-invalid @enderror" id="departmentName" value="{{ $department->name }}" placeholder="مثال: فروش و بازاریابی" required/>
                                    @error('departmentName')
                                        <span class="invalid-feedback" role="alert">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="is_hidden" value="1" id="isHiddenCheckbox" class="custom-control-input" {{ $department->is_hidden ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="isHiddenCheckbox">مخفی باشد</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection