@extends('layouts.master-blank')
@section('title','ارسال مجدد لینک فعالسازی')

@section('content')
    <div class="account-pages mt-5 mb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card">

                        <div class="card-body p-4">

                            <div class="text-center w-75 m-auto">
                                <a href="{{ config('site_url') }}">
                                    @if(config('site_logo'))
                                        <h1 class="text-logo-lg">{{ config('site_logo') }}</h1>
                                    @else
                                        <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                                    @endif
                                </a>
                                <p class="text-muted mb-4 mt-3">ایمیل خود را وارد کنید و ما برای شما لینک فعالسازی را مجددا ارسال خواهیم کرد</p>
                            </div>
                            @error('error')
                                <div class="alert alert- alert-danger">{{ $message }}</div>
                            @enderror
                            @if(session('success'))
                                <div class="alert alert-success">ایمیل تایید حساب کاربری مجددا برای شما ارسال شد لطفا برای تایید حساب کاربری ایمیل خود را بررسی کنید</div>
                            @endif
                            <form action="{{ route('verify.email.resend') }}" method="post">
                                @csrf
                                <div class="form-group mb-3">
                                    <label for="emailaddress">آدرس ایمیل</label>
                                    <input class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}" name="email" type="email" id="emailaddress" placeholder="ایمیل خود را وارد کنید.." required/>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-0 text-center">
                                    <button class="btn btn-primary btn-block" type="submit">ارسال مجدد لینک فعالسازی</button>
                                </div>
                            </form>
                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                    <div class="row mt-3">
                        <div class="col-12 text-center">
                            <p>بازگشت به<a href="{{ route('login') }}" class="font-weight-medium ml-1">صفحه ورود</a></p>
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->


    @component('components.copyright') @endcomponent
@endsection