<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */
use App\User;
use Illuminate\Support\Str;
use Faker\Generator as Faker;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
*/

$factory->define(\App\Ticket::class, function (Faker $faker) {
    $status = ['unread', 'read', 'replied', 'referred', 'replied_pv'];
    return [
        'subject' => $faker->sentence,
        'user_id' => random_int(1,2),
        'content' => $faker->sentence,
        'status' => $status[random_int(0,4)],
        'department_id' => 1,
        'priority' => random_int(1,4),
        'track_id' => random_int(100000,999999),
        'created_at' => now()->subDays(random_int(0, 10))
    ];
});
