<?php

namespace App\Mail\tickets;

use App\Reply;
use App\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserReplied extends Mailable
{
    use Queueable;
    use SerializesModels;

    public $ticket;
    public $reply;

    /**
     * Create a new message instance.
     *
     * @param Ticket $ticket
     * @param Reply $reply
     */
    public function __construct(Ticket $ticket, Reply $reply)
    {
        $this->ticket = $ticket;
        $this->reply = $reply;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('تیکت با موضوع ' . $this->ticket->subject . ' پاسخ جدیدی دریافت کرد ' . '[' . config('site_title', config('app.name')) . ']')
            ->markdown('emails.tickets.replied-by-user');
    }
}
