<?php

namespace App\Http\Controllers\panel;

use App\Http\Controllers\Controller;
use App\Report;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function __construct()
    {
        $this->authorizeResource(Report::class);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $reports = Report::with('ticket', 'reply', 'reply.user', 'user')->paginate(10);
        return view('panel.reports.list', compact('reports'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $request->validate([
           'content' => 'required|min:10',
           'ticket_id' => 'required|exists:tickets,id',
           'reply_id' => 'nullable|exists:replies,id'
        ]);

        $data = $request->all();
        $data['user_id'] = auth()->user()->id;

        Report::create($data);

        return response()->json(['status' => 'success', 'msg' => 'با موفقیت انجام شد']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Report  $report
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Report $report)
    {
        $report->read_at = Carbon::now();
        $report->save();

        return view('panel.reports.show', compact('report'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Report  $report
     * @return \Illuminate\Http\Response
     */
    public function edit(Report $report)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Report  $report
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Report $report)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Report  $report
     * @return \Illuminate\Http\Response
     */
    public function destroy(Report $report)
    {
        //
    }
}
