<?php

namespace App\Notifications\Tickets;

use App\Reply;
use App\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;

class UserReplied extends Notification
{
    use Queueable;

    public $ticket;
    public $reply;

    /**
     * Create a new notification instance.
     *
     * @param Ticket $ticket
     * @param Reply $reply
     */
    public function __construct(Ticket $ticket, Reply $reply)
    {
        $this->ticket = $ticket;
        $this->reply = $reply;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title' => 'پاسخ جدیدی دریافت شد',
            'text' => 'تیکت با موضوع ' . $this->ticket->subject . ' پاسخ جدیدی دریافت کرد ',
            'url' => route('panel.tickets.show', $this->ticket) . '#reply-' . $this->reply->id
        ];
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'data' => [
                'title' => 'پاسخ جدیدی دریافت شد',
                'text' => 'تیکت با موضوع ' . $this->ticket->subject . ' پاسخ جدیدی دریافت کرد ',
                'url' => route('panel.tickets.show', $this->ticket) . '#reply-' . $this->reply->id
            ]
        ]);
    }
}
