@extends('layouts.master-blank')
@section('title','صفحه ورود')
@section('content')
<div class="account-pages mt-5 mb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 col-xl-5">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="text-center w-75 m-auto">
                            <a href="{{ config('site_url') }}">
                                @if(config('site_logo'))
                                    <h1 class="text-logo-lg">{{ config('site_logo') }}</h1>
                                @else
                                    <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                                @endif
                            </a>
                            <p class="text-muted mb-4 mt-3">لطفا جهت ورود به سیستم اطلاعات کاربری خود را در کادر پایین وارد نمایید</p>
                        </div>
                        @if(session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif
                        @error('auth_result')
                            <div class="alert alert- alert-danger">{{ $message }}</div>
                        @enderror
                        <form action="{{ route('login') }}" method="post" id="loginForm">
                            @csrf
                            <div class="form-group mb-3">
                                <label for="username">نام کاربری</label>
                                <input class="form-control @error('username') is-invalid @enderror" type="text" id="username" name="username" value="{{ old('username') }}" placeholder="ایمیل یا شماره موبایل یا نام کاربری" required/>
                                @error('username')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-3">
                                <label for="LoginPassword">کلمه عبور</label>
                                <input class="form-control @error('password') is-invalid @enderror" type="password" name="password" id="LoginPassword" placeholder="کلمه عبور خود را وارد نمایید" required>
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group mb-3">
                                <div class="custom-control custom-checkbox d-inline-block mb-2">
                                    <input type="checkbox" name="remember" class="custom-control-input" id="checkbox-signin" {{ old('remember') ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="checkbox-signin">مرا به خاطر بسپار</label>
                                </div>
                                <div class="d-inline-block float-right">
                                    <a class="ml-1" href="{{ route('password.request') }}">
                                        {{ __('general.Forgot Your Password?') }}
                                    </a>
                                </div>
                            </div>

                            <div class="form-group mb-0 text-center">

                                @if(config('use_google_nocaptcha'))
                                    <button class="btn btn-primary btn-block g-recaptcha" data-sitekey="{{ config('google_nocaptcha_sitekey') }}" data-callback='onSubmit' type="submit"> ورود </button>
                                @else
                                    <button class="btn btn-primary btn-block" type="submit"> ورود </button>
                                @endif
                            </div>
                        </form>
                        <!-- <div class="text-center">
                            <h5 class="mt-3 text-muted">Sign in with</h5>
                            <ul class="social-list list-inline mt-3 mb-0">
                                <li class="list-inline-item">
                                    <a href="javascript: void(0);" class="social-list-item border-primary text-primary"><i class="mdi mdi-facebook"></i></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="javascript: void(0);" class="social-list-item border-danger text-danger"><i class="mdi mdi-google"></i></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="javascript: void(0);" class="social-list-item border-info text-info"><i class="mdi mdi-twitter"></i></a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="javascript: void(0);" class="social-list-item border-secondary text-secondary"><i class="mdi mdi-github-circle"></i></a>
                                </li>
                            </ul>
                        </div> -->

                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->

                @if(Route::has('register'))
                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <p class="text-muted">حساب کاربری ندارید؟ <a href="{{ route('register') }}" class="text-primary font-weight-medium ml-1">ثبت نام کنید</a></p>
                    </div> <!-- end col -->
                </div>
                <!-- end row -->
                @endif

            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    <!-- end container -->
</div>
<!-- end page -->

@component('components.copyright') @endcomponent

@endsection

@if(config('use_google_nocaptcha'))
    @section('script')
        <script>
            function onSubmit(token){
                $('#loginForm').submit();
            }
        </script>
    @endsection
@endif