<?php

namespace App\Providers;

use App\Events\SmsSent;
use App\Events\tickets\Created as TicketCreated;
use App\Events\tickets\SuperiorReplied as SuperiorRepliedTicket;
use App\Events\tickets\SuperiorRepliedPrivate as SuperiorRepliedTicketPrivate;
use App\Events\tickets\UserReplied as UserRepliedTicket;
use App\Events\UserRegistered;
use App\Listeners\LogSms;
use App\Listeners\Tickets\InformDepartment;
use App\Listeners\Tickets\InformDepartmentPrivate;
use App\Listeners\Tickets\InformUser;
use App\Listeners\UserRegistered\SendActivationEmail;
use App\Listeners\UserRegistered\SendActivationSMS;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        /*Registered::class => [
            SendEmailVerificationNotification::class,
        ],*/

        // Tickets Events

        UserRegistered::class => [
            SendActivationEmail::class,
            SendActivationSMS::class,
        ],

        TicketCreated::class => [
            InformDepartment::class
        ],

        UserRepliedTicket::class => [
            InformDepartment::class
        ],

        SuperiorRepliedTicket::class => [
            InformUser::class
        ],

        SuperiorRepliedTicketPrivate::class => [
            InformDepartmentPrivate::class
        ],

        // SMS events
        SmsSent::class => [
            LogSms::class
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }
}
