<?php

namespace App\Listeners;

use App\Events\SmsSent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\DB;

class LogSms
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  SmsSent  $event
     * @return void
     */
    public function handle(SmsSent $event)
    {
        DB::table('sms_logs')->insert([
            'from' => $event->data['from'],
            'to' => $event->data['to'],
            'content' => $event->data['text'],
            'status' => $event->data['response'],
        ]);
    }
}
