@extends('layouts.user-panel.master')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/dropzone.min.css') }}">
@endsection

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">ارسال تیکت جدید</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <form action="{{ route('panel.tickets.store') }}" method="post" id="addTicketForm2">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="TicketSubject">موضوع تیکت</label>
                                    <input type="text" name="subject" class="form-control @error('subject') is-invalid @enderror" id="TicketSubject" placeholder="موضوع تیکت را وارد کنید" value="{{ old('subject') }}" required/>
                                    @error('subject')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="TicketPriority">اولویت</label>
                                    <select id="TicketPriority" dir="rtl" name="priority" class="custom-select">
                                        <option value="1" {{ old('priority') == '1' ? 'selected' : '' }}>کم اهمیت</option>
                                        <option value="2" {{ old('priority') == '2' ? 'selected' : '' }}>متوسط</option>
                                        <option value="3" {{ old('priority') == '3' ? 'selected' : '' }}>ضروری</option>
                                        <option value="4" {{ old('priority') == '4' ? 'selected' : '' }}>بحرانی</option>
                                    </select>
                                    @error('priority')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="TicketDepartment">دپارتمان</label>
                                    <select id="TicketDepartment" dir="rtl" name="department" class="custom-select @error('department') is-invalid @enderror" data-live-search="true">
                                        @forelse($departments as $department)
                                            <option value="{{ $department->id }}" {{ old('department') == $department->id ? 'selected' : ''}}>{{ $department->name }}</option>
                                        @empty
                                            <option value="0" disabled>دپارتمانی یافت نشد</option>
                                        @endforelse
                                    </select>
                                    @error('department')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="TicketContent">متن</label>
                                    <textarea name="text" id="TicketContent" class="form-control @error('subject') is-invalid @enderror" cols="30" rows="6" placeholder="متن تیکت را وارد کنید..." required>{{ old('content') }}</textarea>
                                    @error('content')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right ml-1">ذخیره</button>
                                <button class="btn btn-secondary waves-effect waves-light float-right" type="button" data-toggle="modal" data-target="#addFileToTicketModal">
                                    <span>افزودن فایل</span>
                                    (<span class="files-count">0</span>)
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>
    <!-- DROPZONE UPLOAD MODAL -->

    <x-modal title="افزودن فایل به تیکت" id="addFileToTicketModal" size="modal-lg">
        <div class="alert alert-light border-right">
            <span>شما میتوانید حداکثر </span>
            <span class="text-primary">{{ config('upload_max_file_count') }}</span>
            <span> تا فایل آپلود کنید</span>
        </div>
        <div class="alert alert-light border-right">
            <span>هر فایل شما نباید بیشتر از </span>
            <span class="text-primary">{{ config('upload_max_file_size') }}</span>
            <span>  مگابایت حجم داشته باشد</span>
        </div>
        <form action="{{ route('panel.tickets.storeFile') }}" method="post" class="dropzone" id="addFileForm" data-plugin="dropzone" data-previews-container="#file-previews"
              data-upload-preview-template="#uploadPreviewTemplate">
            @csrf
            <div class="fallback">
                <input name="file" type="file" multiple />
            </div>

            <div class="dz-message needsclick">
                <p class="h1 text-muted"><i class="mdi mdi-cloud-upload"></i></p>
                <h3>فایل ها را برای آپلود به اینجا بکشید و رها کنید</h3>
            </div>
        </form>

        <!-- Preview -->
        <div class="dropzone-previews mt-3" id="file-previews"></div>
    </x-modal>
@endsection

@section('script')
    @php
        $timeout = 999;

        if (ini_get('max_input_time') == -1) {
            $timeout = ini_get('max_execution_time');
        } elseif (ini_get('max_input_time') > 0) {
            $timeout = ini_get('max_input_time');
        }

        $timeout *= 1000;
    @endphp
    <script src="{{ asset('assets/js/dropzone.min.js') }}"></script>
    <script>
        var uploadedDocumentMap = {}
        var filesCount = 0
        Dropzone.options.addFileForm = {
            /*url: '',*/
            maxFilesize: '{{ config('upload_max_file_size') }}', // MB
            maxFiles: '{{ config('upload_max_file_count') }}', // MB
            addRemoveLinks: true,
            timeout: '{{ $timeout  }}',
            acceptedFiles: '{{ config('upload_allowed_formats') }}',
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            success: function (file, response) {
                $('#addTicketForm2')
                    .append('<input type="hidden" name="attach[]" value="' + response.name + '" id="' + response.id + '">')
                $('#addTicketForm2')
                    .append('<input type="hidden" name="attachName[]" value="' + response.original_name + '" data-related="#' + response.id + '">')
                uploadedDocumentMap[file.name] = response.name
                $('.files-count').text($('input[name="attach[]"]').length)
            },
            removedfile: function (file) {
                file.previewElement.remove()
                var name = ''
                if (typeof file.file_name !== 'undefined') {
                    name = file.file_name
                } else {
                    name = uploadedDocumentMap[file.name]
                }
                var attachInput = $('#addTicketForm2').find('input[name="attach[]"][value="' + name + '"]');
                attachInput.remove();
                $('#addTicketForm2').find('[data-related="#' + attachInput.attr('id') + '"]').remove()
                $('.files-count').text($('input[name="attach[]"]').length)
            },
        }
    </script>

@endsection
