@extends('layouts.master')
@section('title', 'تنظیمات پوسته و طراحی')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.settings.general') }}">تنظیمات</a></li>
                        <li class="breadcrumb-item active">پوسته و طراحی</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات پوسته و طراحی</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                <form action="{{ route('panel.settings.template.update') }}" class="form-horizontal" method="post" role="form" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="ShowOpenHoursSection">نمایش ساعات کاری</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="ShowOpenHoursSection" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="showOpenHoursSection" @if($settings['showOpenHoursSection']) checked @endif value="1"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="OpenDays">روز های کاری</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="text" id="OpenDays" class="form-control" name="openDays" value="{{ $settings['openDays'] }}" placeholder="مثال: شنبه تا چهارشنبه"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="OpenHours">ساعات کاری</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="text" id="OpenHours" class="form-control" name="openHours" value="{{ $settings['openHours'] ?? '' }}" placeholder="مثال: 06 - 17"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="Phone">شماره تماس</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="text" id="Phone" class="form-control" name="phone" value="{{ $settings['phone'] ?? '' }}" placeholder="مثال: 021 - 123456789"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="ShowOurTeamSection">نمایش بخش تیم ما</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="ShowOurTeamSection" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="showOurTeamSection" @if($settings['showOurTeamSection']) checked @endif value="1"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="OurTeamHeader">عنوان بخش تیم ما</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="text" id="OurTeamHeader" class="form-control" name="ourTeamHeader" value="{{ $settings['ourTeamHeader'] ?? '' }}" placeholder="عنوان را وارد کنید"/>
                        </div>
                    </div>
                    <div class="alert alert-light border-left-0 border-top-0 border-bottom-0 border-warning">برای عدم نمایش هر عضو نام و نام خانوادگی را خالی رها کنید</div>
                    @forelse($settings['teamMembers'] as $teamMember)
                        <input type="hidden" name="members[]" value="{{ $loop->iteration }}">
                        <input type="hidden" name="preavatars[]" value="{{ $teamMember['avatar'] ?? null }}">
                        <fieldset class="border border-light p-3 mb-4">
                            <legend>عضو {{ $loop->iteration }}</legend>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Name">نام و نام خانوادگی</label>
                                <div class="col-sm-10">
                                    <input type="text" id="Member-{{ $loop->iteration }}-Name" class="form-control" name="names[]" value="{{ $teamMember['name'] ?? '' }}" placeholder="نام و نام خانوادگی را وارد کنید"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Position">سمت</label>
                                <div class="col-sm-10">
                                    <input type="text" id="Member-{{ $loop->iteration }}-Position" class="form-control" name="positions[]" value="{{ $teamMember['position'] ?? '' }}" placeholder="مثال: مدیر فنی"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Bio">توضیحات</label>
                                <div class="col-sm-10">
                                    <textarea name="bios[]" id="Member-{{ $loop->iteration }}-Bio" cols="30" rows="6" class="form-control" placeholder="درباره فرد بنویسید...">{{ $teamMember['bio'] ?? '' }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="email" class="col-sm-2 col-form-label">تصویر پروفایل</label>
                                <div class="col-sm-10">
                                    <img class="rounded-circle mr-2" src="{{ asset('files/' . $teamMember['avatar']) ?? asset('assets/images/default-avatar.png') }}" width="33" alt="تصویر پروفایل">
                                    <div class="fileupload btn btn-xs btn-secondary waves-effect mt-1">
                                        <span><i class="mdi mdi-cloud-upload mr-1"></i>انتخاب تصویر جدید</span>
                                        <input type="file" name="avatars[{{ $loop->index }}]" class="upload">
                                    </div>
                                    @error('avatar')
                                    <span class="text-danger" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Telegram">تلگرام</label>
                                <div class="col-sm-10">
                                    <input type="url" id="Member-{{ $loop->iteration }}-Telegram" class="form-control" name="telegrams[]" value="{{ $teamMember['telegram'] ?? '' }}" placeholder="https://t.me/username"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Instagram">اینستاگرام</label>
                                <div class="col-sm-10">
                                    <input type="url" id="Member-{{ $loop->iteration }}-Instagram" class="form-control" name="instagrams[]" value="{{ $teamMember['instagram'] ?? '' }}" placeholder="https://instagram.com/profile/username"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Twitter">توییتر</label>
                                <div class="col-sm-10">
                                    <input type="url" id="Member-{{ $loop->iteration }}-Twitter" class="form-control" name="twitters[]" value="{{ $teamMember['twitter'] ?? '' }}" placeholder="https://twitter.com/username"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="Member-{{ $loop->iteration }}-Linkedin">لینکداین</label>
                                <div class="col-sm-10">
                                    <input type="url" id="Member-{{ $loop->iteration }}-Linkedin" class="form-control" name="linkedins[]" value="{{ $teamMember['linkedin'] ?? '' }}" placeholder="https://linkedin.com/username"/>
                                </div>
                            </div>
                        </fieldset>
                    @empty
                        <div class="alert alert-light">شما هنوز عضوی اضافه نکرده اید</div>
                    @endforelse
                    <fieldset>
                        <legend></legend>
                    </fieldset>
                    <div class="clearfix border-top pt-2 border-light">
                        <button class="btn btn-primary float-right" type="submit">ذخیره</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script src="{{ asset('assets/js/jquery.bootstrap-touchspin.min.js') }}"></script>

    <script>
        $("#MaximumTicketsAttachesCount").TouchSpin({
            min: 0,
            max: 10000000000,
            buttondown_class: "btn btn-primary",
            buttonup_class: "btn btn-primary",
            postfix: "تا"
        });
        $("#MaximumTicketsAttachesSize").TouchSpin({
            min: 0,
            max: 1000000000,
            buttondown_class: "btn btn-primary",
            buttonup_class: "btn btn-primary",
            prefix: "MB"
        })
    </script>
@endsection