@extends('layouts.master')
@section('title', 'افزودن پاسخ آماده جدید')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.quick-responses.index') }}">پاسخ‌های آماده</a></li>
                        <li class="breadcrumb-item active">افزودن پاسخ آماده</li>
                    </ol>
                </div>
                <h4 class="page-title">افزودن پاسخ آماده جدید</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات پاسخ آماده</h4>
                </div>
                <form action="{{ route('panel.quick-responses.store') }}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="title">عنوان</label>
                                    <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" id="title" placeholder="مثال: تیکت شما در حال بررسی است" value="{{ old('title') }}" required/>
                                    @error('title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="text">متن</label>
                                    <textarea type="text" name="text" class="form-control @error('text') is-invalid @enderror" id="text" rows="8" placeholder="مثال: تیکت شما در حا بررسی می‌باشد لطفا تا حصول نتیجه شکیبا باشید" required>{{ old('text') }}</textarea>
                                    @error('text')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection