@extends('layouts.master')
@section('title', 'افزودن دپارتمان جدید')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.departments.index') }}">دپارتمان ها</a></li>
                        <li class="breadcrumb-item active">افزودن دپارتمان</li>
                    </ol>
                </div>
                <h4 class="page-title">افزودن دپارتمان جدید</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات دپارتمان</h4>
                </div>
                <form action="{{ route('panel.departments.store') }}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="departmentName">عنوان دپارتمان</label>
                                    <input type="text" name="departmentName" class="form-control" id="departmentName" placeholder="مثال: فروش و بازاریابی" value="{{ old('departmentName') }}" required/>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="isHidden" value="1" id="isHiddenCheckbox" class="custom-control-input">
                                        <label class="custom-control-label" for="isHiddenCheckbox">مخفی باشد</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection