<!-- ADD NEW DEPARTMENT MODAL -->

<x-modal title="افزودن دپارتمان جدید" id="addDepartmentModal" formId="addDepartmentForm" isAjax="true" action="{{ route('panel.departments.store') }}" method="post" redirectUrl="{{ route('panel.departments.index') }}">
    <div class="form-group">
        <label for="departmentName">عنوان دپارتمان</label>
        <input type="text" name="departmentName" class="form-control" id="departmentName" placeholder="مثال: حسابداری" required/>
    </div>
    <div class="form-group">
        <div class="custom-control custom-checkbox">
            <input type="checkbox" name="isHidden" value="1" id="isHiddenCheckbox" class="custom-control-input">
            <label class="custom-control-label" for="isHiddenCheckbox">مخفی باشد</label>
        </div>
    </div>
    <div class="my-2">
        <a href="{{ route('panel.departments.create') }}">باز کردن فرم در صفحه جدید</a>
    </div>
    <div class="result alert" style="display:none"></div>
</x-modal>

<!-- ADD NEW USER MODAL -->

<x-modal title="افزودن کاربر جدید" id="addUserModal" size="modal-lg" formId="addUserForm" isAjax="true" action="{{ route('panel.users.store') }}" method="post" redirectUrl="{{ route('panel.users.index') }}">
    <div class="form-group">
        <label for="Username">نام و نام خانوادگی</label>
        <input type="text" name="name" class="form-control" id="UserName" placeholder="نام و نام خانوادگی را وارد کنید" required/>
    </div>
    <div class="form-group">
        <label for="UserEmail">ایمیل</label>
        <input type="email" name="email" class="form-control" id="UserEmail" placeholder="مثال: email@site.com" required/>
    </div>
    <div class="form-group">
        <label for="UserMobile">شماره موبایل</label>
        <input type="text" name="mobile" class="form-control" id="UserMobile" placeholder="مثال: 09123456789" pattern="09\d{9}" title="شماره موبایل 11 رقمی مانند : 09123456789" required/>
    </div>
    <div class="form-group">
        <label for="UserUsername">نام کاربری</label>
        <input type="text" name="username" class="form-control" size="20" maxlength="20" id="UserUsername" placeholder="مثال: ali_22" pattern="[a-zA-Z0-9-_]{,20}" title="تنها اجازه استفاده از کارکتر های عددی،حروف،خط تیره و زیرخط را دارید" required/>
        <span class="form-text text-muted">حداکثر 20 کارکتر.کارکترهای مجاز: اعداد ، حروف ، خط تیره(-) ، زیرخط(ــــ)</span>
    </div>
    <div class="form-group">
        <label for="UserPassword">کلمه عبور</label>
        <input type="password" name="password" class="form-control" id="UserPassword" placeholder="کلمه عبور را وارد کنید" minlength="8" required/>
    </div>
    <div class="form-group">
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="UserActive" name="status" value="active" checked>
            <label class="custom-control-label" for="UserActive">فعال باشد</label>
        </div>
    </div>
    <div class="form-group">
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" name="needVerification" value="true" id="UserNeedVerification">
            <label class="custom-control-label" for="UserNeedVerification">نیاز به تایید اطلاعات</label>
            <span class="remixicon-question-fill" data-toggle="tooltip" title="در صورت فعال بود این گزینه کاربر میبایست شماره همراه و ایمیل خود را تایید کند(باتوجه به تنظیمات)"></span>
        </div>
    </div>
    <div class="my-2">
        <a href="{{ route('panel.users.create') }}">باز کردن فرم در صفحه جدید</a>
    </div>
    <div class="result alert" style="display:none"></div>
</x-modal>

<!-- ADD NEW STAFF MODAL -->

<x-modal title="افزودن پشتیبان جدید" id="addStaffModal" size="modal-lg" formId="addStaffForm" isAjax="true" action="{{ route('panel.staffs.store') }}" method="post" redirectUrl="{{ route('panel.staffs.index') }}">
    <div class="form-group">
        <label for="StaffName">نام و نام خانوادگی</label>
        <input type="text" name="name" class="form-control" id="StaffName" placeholder="نام و نام خانوادگی را وارد کنید" required/>
    </div>
    <div class="form-group">
        <label for="StaffEmail">ایمیل</label>
        <input type="email" name="email" class="form-control" id="StaffEmail" placeholder="مثال: email@site.com" required/>
    </div>
    <div class="form-group">
        <label for="StaffMobile">شماره موبایل</label>
        <input type="text" name="mobile" class="form-control" id="StaffMobile" placeholder="مثال: 09123456789" pattern="09\d{9}" title="شماره موبایل 11 رقمی مانند : 09123456789" required/>
    </div>
    <div class="form-group">
        <label for="StaffUsername">نام کاربری</label>
        <input type="text" name="username" class="form-control" size="20" maxlength="20" id="StaffUsername" placeholder="مثال: ali_22" pattern="[a-zA-Z0-9-_]{,20}" title="تنها اجازه استفاده از کارکتر های عددی،حروف،خط تیره و زیرخط را دارید" required/>
        <span class="form-text text-muted">حداکثر 20 کارکتر.کارکترهای مجاز: اعداد ، حروف ، خط تیره(-) ، زیرخط(ــــ)</span>
    </div>
    <div class="form-group">
        <label for="StaffPassword">کلمه عبور</label>
        <input type="password" name="password" class="form-control" id="StaffPassword" placeholder="کلمه عبور را وارد کنید" minlength="8" required/>
    </div>
    <div class="form-group">
        <label for="StaffDepartments">دپارتمان</label>
        <select id="StaffDepartments" dir="rtl" name="departments[]" class="selectpicker" multiple data-selected-text-format="count > 3" data-live-search="true">
            @forelse(\App\Department::all() as $department)
                <option value="{{ $department->id }}">{{ $department->name }}</option>
            @empty
                <option value="0" disabled>دپارتمانی یافت نشد</option>
            @endforelse
        </select>
    </div>
    <div class="form-group">
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="active" name="status" value="active" checked>
            <label class="custom-control-label" for="active">فعال باشد</label>
        </div>
    </div>
    <div class="form-group">
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" name="needVerification" value="true" id="needsVerification">
            <label class="custom-control-label" for="needsVerification">نیاز به تایید اطلاعات</label>
            <span class="remixicon-question-fill" data-toggle="tooltip" title="در صورت فعال بود این گزینه کاربر میبایست شماره همراه و ایمیل خود را تایید کند(باتوجه به تنظیمات)"></span>
        </div>
    </div>
    <div class="my-2">
        <a href="{{ route('panel.staffs.create') }}">باز کردن فرم در صفحه جدید</a>
    </div>
    <div class="result alert" style="display:none"></div>
</x-modal>

<!-- ADD NEW TICKET MODAL -->


<x-modal title="افزودن تیکت جدید" id="addTicketModal" size="modal-lg" formId="addTicketForm" isAjax="true" action="{{ route('panel.tickets.store') }}" method="post" redirectUrl="{{ route('panel.tickets.index') }}">
    <div class="form-group">
        <label for="TicketSubject">موضوع تیکت</label>
        <input type="text" name="subject" class="form-control" id="TicketSubject" placeholder="موضوع تیکت را وارد کنید" required/>
    </div>
    <div class="form-group">
        <label for="TicketPriority">اولویت</label>
        <select id="TicketPriority" dir="rtl" name="priority" class="selectpicker">
            <option value="1">کم اهمیت</option>
            <option value="2">متوسط</option>
            <option value="3">ضروری</option>
            <option value="4">بحرانی</option>
        </select>
    </div>
    <div class="form-group">
        <label for="TicketDepartment">دپارتمان</label>
        <select id="TicketDepartment" dir="rtl" name="department" class="selectpicker" data-live-search="true">
            @forelse(\App\Department::all() as $department)
                <option value="{{ $department->id }}">{{ $department->name }}</option>
            @empty
                <option value="0" disabled>دپارتمانی یافت نشد</option>
            @endforelse
        </select>
    </div>
    <div class="form-group">
        <label for="TicketUser">کاربر</label>
        <select id="TicketUser"
                dir="rtl"
                name="user"
                class="form-control select2-ajax"
                data-ajax-url="{{ route('panel.users.search') }}"
                data-placeholder="کاربر را انتخاب کنید">
            <option></option>
        </select>
    </div>
    <div class="form-group">
        <label for="TicketContent">متن</label>
        <textarea name="text" id="TicketContent" class="form-control" cols="30" rows="6" placeholder="متن تیکت را وارد کنید..."></textarea>
    </div>
    <div class="my-2">
        <a href="{{ route('panel.tickets.create') }}">باز کردن فرم در صفحه جدید</a>
    </div>
    <div class="result alert" style="display:none"></div>
</x-modal>
