<?php

namespace App\Http\Controllers;

use App\Post;
use App\Services\PatronicService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;

class HomeController extends Controller
{
    public function index()
    {
        if (!config('site_homepage_enabled')) {
            return redirect()->route('login');
        }
        $news = Post::whereType('news')->whereStatus('public')->latest()->take(5)->get();
        $faq = Post::whereType('faq')->whereStatus('public')->latest()->take(5)->get();
        /*$configs = [
            'showOpenHoursSection' => true,
            'openDays' => 'شنبه تا چهار شنبه',
            'openHours' => 'شنبه تا چهار شنبه',
            'phone' => 'شنبه تا چهار شنبه',
            'showOurTeamSection' => true,
            'ourTeamHeader' => 'چه کسانی در پاترونیک پاسخگوی شما هستند',
            'teamMembers' => [
                ['name' => 'Mahyar Ansary', 'about' => 'About Mahay Ansary', 'social'=> ['telegram' => 'mransary']],
                ['name' => 'yashar Ansary', 'about' => 'About Mahay Ansary', 'social'=> ['telegram' => 'mransary']],
                ['name' => 'reza Ansary', 'about' => 'About Mahay Ansary', 'social'=> ['telegram' => 'mransary']],
            ],
        ];*/
        $templateConfigs = json_decode(getconfig('site_template'), true);
        $currentRouteName = Route::currentRouteName();

        return view('main', compact('news', 'faq', 'templateConfigs', 'currentRouteName'));
    }

    public function showAllNews()
    {
        $news = Post::whereType('news')->latest()->paginate(20);
        return view('public.news', compact('news'));
    }

    public function showAllFaqs()
    {
        $faqs = Post::whereType('faq')->latest()->paginate(20);
        return view('public.faqs', compact('faqs'));
    }

    public function search(Request $request)
    {
        $searchTerm = $request->s;

        if ($searchTerm) {
            $posts = Post::where('title', 'like', "%$searchTerm%")
                ->orWhere('content', 'like', "%$searchTerm%")
                ->paginate(10);

            return view('public.search', compact('searchTerm', 'posts'));
        } else {
            return redirect()->back();
        }
    }

    public function getLatestNews(Request $request, PatronicService $service)
    {
        $patronicNews = $service->getLastNews();
        return View::make('partials.patronic-news', compact('patronicNews'))->render();
    }
}
