<?php

namespace App\Events;

use App\User;
use App\Verification;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UserRegistered
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public $user;
    public $verificationToken;
    public $verificationId;
    public $mobileVerificationCode;

    /**
     * Create a new event instance.
     *
     * @param User $user
     * @param Verification $verification
     * @param Verification|null $mobileVerification
     */
    public function __construct(User $user, Verification $verification, ?Verification $mobileVerification)
    {
        $this->user = $user;
        if ($verification->type == 'email' and !$mobileVerification) {
            $this->verificationToken = $verification->token ?? null;
            $this->verificationId = $verification->id ?? null;
        } elseif ($verification->type == 'sms') {
            $this->mobileVerificationCode = $verification->token;
        } elseif ($mobileVerification) {
            $this->mobileVerificationCode = $mobileVerification->token;
            $this->verificationId = $verification->id ?? null;
            $this->verificationToken = $verification->token ?? null;
        }
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
