@extends('layouts.setup.master')

@section('content')

<div class="container mt-5">
    <div class="card">
        <div class="card-body">
            <div class="text-center mb-1 float-right">
                <a href="https://patronic.ir" class="text-muted" target="_blank">
                <img src="{{ asset('assets/images/patronic-logo-dark.png') }}" alt="سیستم پشتیبانی و ارسال تیکت پاترونیک" class="mb-1" height="35">
                <p>www.patronic.ir</p>
                </a>
            </div>
            <h3 class="card-title">مرحله دوم نصب - تایید لایسنس</h3>
            <p class="card-subtitle">بررسی لایسنس محصول جهت تایید خرید</p>
            <hr>
            <div class="row">

                @include('layouts.setup.vertical-tabs')

                <div class="col-9">
                    <div class="tab-content pt-0" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-license-check" role="tabpanel" aria-labelledby="v-pills-license-check-tab">
                            @error('licenseError')
                                <div class="alert alert-danger"><strong>خطا! </strong>{{ $message }}</div>
                            @enderror
                            <form action="{{ route('setup.handle', ['step' => 2]) }}" method="post">
                                @csrf
                                <div class="form-group">
                                    <label for="LicenseUsername">نام کاربری شما در سایت راستچین</label>
                                    <input type="text" class="form-control @error('licenseUsername') is-invalid @enderror" value="{{ old('licenseUsername') }}" id="LicenseUsername" name="licenseUsername" placeholder="مثال: patronic" required>
                                    @error('licenseUsername')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="LicenseOrderId">کد سفارش خرید محصول</label>
                                    <input type="text" class="form-control @error('licenseOrderId') is-invalid @enderror" value="{{ old('licenseOrderId') }}" id="LicenseOrderId" name="licenseOrderId" placeholder="مثال: 334987654321" required>
                                    @error('licenseOrderId')
                                    <div class="invalid-feedback">
                                        <span>{{ $message }}</span>
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="licenseDomain">آدرس سایت</label>
                                    <input type="text" class="form-control @error('licenseDomain') is-invalid @enderror" id="LicenseAddress" name="licenseDomain" value="{{ url('/') }}" readonly>
                                    @error('licenseDomain')
                                        <div class="invalid-feedback">
                                            <span>{{ $message }}</span>
                                        </div>
                                    @else
                                        <small class="form-text text-muted">لایسنس برای این آدرس ثبت میشود و تنها امکان <span class="text-warning">یکبار نصب و استفاده</span> از پاترونیک بروی این دامنه امکان پذیر خواهد بود</small>
                                    @enderror
                                </div>
                                <div class="form-group clearfix">
                                    <button type="submit" class="btn btn-primary float-right">مرحله بعد</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection