@extends('layouts.master')
@section('title', 'پشتیبانان')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">پشتیبانان</li>
                    </ol>
                </div>
                <h4 class="page-title">پشتیبانان</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="clearfix">
                        <div class="float-left">
                            <h4 class="header-title">لیست پشتیبانان</h4>
                            <p class="sub-header">لیست تمامی پشتیبانان به همراه اطلاعات</p>
                        </div>
                        <a href="{{ route('panel.staffs.create') }}" class="btn btn-primary waves-effect waves-light float-right mb-3"><i class="fe-user-plus mr-2"></i>افزودن پشتیبان جدید</a>
                    </div>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>نام و نام خانوادگی</th>
                            <th>دپارتمان</th>
                            <th>ایمیل</th>
                            <th>شماره همراه</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($staffs as $staff)
                            <tr>
                                <td>{{ $staff->id }}</td>
                                <td>{{ $staff->name }}</td>
                                <td>
                                    @foreach($staff->departments as $department)
                                        <label class="badge badge-light-info">{{ $department->name }}</label>
                                    @endforeach
                                </td>
                                <td>{{ $staff->email }}</td>
                                <td>{{ $staff->mobile }}</td>
                                <td>
                                    <a href="{{ route('panel.staffs.edit', $staff) }}" class="btn btn-secondary btn-xs">
                                        <span class="remixicon-user-settings-line"></span>
                                    </a>
                                    <a href="javascript:void(0)" class="btn btn-danger btn-xs" data-delete-url="{{ route('panel.staffs.destroy', $staff) }}">
                                        <span class="remixicon-user-unfollow-line"></span>
                                    </a>
                                    <div class="btn-group dropdown">
                                        <a href="javascript: void(0);" class="dropdown-toggle arrow-none btn btn-light btn-sm" data-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-dots-horizontal"></i></a>
                                        <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(39px, 29px, 0px);">
                                            <a class="dropdown-item" href="#">ارسال اعلان<i class="mdi mdi-message-text-outline mr-2 text-muted font-18 vertical-middle"></i></a>
                                            <a class="dropdown-item" href="#">ارسال پیامک<i class="mdi mdi-cellphone-message mr-2 font-18 text-muted vertical-middle"></i></a>
                                            <a class="dropdown-item" href="#">مسدود کردن<i class="mdi mdi-minus-circle-outline  mr-2 font-18 text-muted vertical-middle"></i></a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <td colspan="6" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $staffs->links() }}
            </div>
        </div><!-- end col -->
    </div>

@endsection

@section('script')

@endsection

@section('script-bottom')
    <!-- init js -->

@endsection