@extends('layouts.master')
@section('title', 'تنظیمات پیامک')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.settings.general') }}">تنظیمات</a></li>
                        <li class="breadcrumb-item active">پیامک</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات پیامک</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box" style="overflow: hidden">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <form action="{{ route('panel.settings.sms.update') }}" class="form-horizontal" method="post" role="form">
                    @method('patch')
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="smsUsername">سامانه پیامکی</label>
                        <div class="col-sm-10">
                            <select name="sms_settings[driver]" id="smsDriver" class="custom-select">
                                <option disabled {{ !in_array($activeDriver, array_keys($smsDrivers)) ? 'selected' : '' }}>
                                    سامانه پیامکی را انتخاب کنید
                                </option>
                                @foreach($smsDrivers as $driver => $driverOptions)
                                    <option value="{{ $driver }}" {{ $activeDriver == $driver ? 'selected' : '' }}>{{ $driverOptions['name'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div id="smsDriverSettings" class="bg-light p-3">
                        @include($driverSettingsPath)
                    </div>
                    <div class="border-top pt-2 border-light text-center">
                        <button class="btn btn-primary" type="submit">ذخیره</button>
                    </div>
                </form>
                <hr class="border-light"/>
                <h5 class="card-title">ارسال آزمایشی</h5>
                <form action="{{ route('panel.sms.sendTest') }}" role="form" id="sendTestSmsForm">
                    <div class="input-group">
                        <input type="text" class="form-control" id="mobile" placeholder="شماره موبایل" aria-label="شماره موبایل">
                        <div class="input-group-append">
                            <button class="btn btn-secondary waves-effect waves-light" type="submit">ارسال پیامک
                                آزمایشی
                            </button>
                        </div>
                    </div>
                    <small class="form-text text-muted">ارسال آزمایشی به صورت عادی ارسال خواهد شد و نه ارسال با
                        پترن.بنابراین پیش از ارسال آزمایشی می‌بایستی نام کاربری،کلمه‌عبور و شماره را تکمیل کنید</small>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script-bottom')

    <script>
        function copyTextToClipboard(text) {
            var textArea = document.createElement("textarea");
            textArea.value = text
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                var successful = document.execCommand('copy');
                var msg = successful ? 'successful' : 'unsuccessful';

            } catch (err) {
                console.log('Oops, unable to copy');
            }

            document.body.removeChild(textArea);
        }

        $(document).ready(function () {
            $('body').on('change', '#usePatterns', function () {
                if ($(this).prop('checked') === false) {
                    $('#patternsSection').slideUp();
                    $('#smsNumber').removeAttr('readonly');
                } else {
                    $('#patternsSection').slideDown();
                    $('#smsNumber').attr('readonly', 'readonly');
                }
            });


            $('#smsDriver').change(function () {
                $('#smsDriverSettings').css('opacity', '0.4')
                let driver = $(this).val()
                $.get("{{ route('panel.settings.sms.loadSettings') }}", {driver: driver}, function (res) {
                    $('#smsDriverSettings').css('opacity', 1).html(res)
                })
            })

        }); // doc ready
    </script>
@endpush