@extends('layouts.master-blank')
@section('title','عضویت')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/passtrength.min.css') }}"/>
@endsection

@section('content')
<div class="account-pages mt-5 mb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 col-xl-5">
                <div class="card">

                    <div class="card-body p-4">

                        <div class="text-center w-75 m-auto">
                            <a href="{{ config('site_url') }}">
                                @if(config('site_logo'))
                                    <h1 class="text-logo-lg">{{ config('site_logo') }}</h1>
                                @else
                                    <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                                @endif
                            </a>
                            <p class="text-muted mb-4 mt-3">با ایجاد حساب کاربری امکان ورود به ناحیه کاربری و استفاده از خدمات سایت فراهم خواهد شد</p>
                        </div>

                        @if(session('error'))<div class="alert alert-danger">{{ session('error') }}</div><br>@endif
                        @if(session('success'))<div class="alert alert-success">{{ session('success') }}</div><br>@endif

                        <form method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="form-group">
                                <label for="fullname">نام و نام خانوادگی</label>
                                <input class="form-control @error('name') is-invalid @enderror" type="text" name="name" id="fullname" value="{{ old('name') }}" placeholder="نام و نام خانوادگی خود را وارد کنید" required/>
                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="emailaddress">ایمیل</label>
                                <input class="form-control @error('email') is-invalid @enderror" type="email" id="emailaddress" name="email" value="{{ old('email') }}" placeholder="مثال: user@site.com" required/>
                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="mobile">موبایل</label>
                                <input class="form-control @error('mobile') is-invalid @enderror" type="text" id="mobile" name="mobile" value="{{ old('mobile') }}" placeholder="مثال: 09123456789" required/>
                                @error('mobile')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="password">کلمه عبور</label>
                                <input class="form-control @error('password') is-invalid @enderror" type="password" name="password" id="password" placeholder="کلمه عبور خود را وارد کنید" required/>
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" name="rules" class="custom-control-input" id="AcceptRules">
                                    <label class="custom-control-label" for="AcceptRules">
                                        <span class="text-primary" style="cursor:pointer" data-toggle="modal" data-target="#RulesModal">قوانین و مقررات</span>
                                        را پذیرفتم
                                    </label>
                                    @error('rules')
                                    <p><small class="text-danger">{{ $message }}</small></p>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="form-group mt-3 mb-0 text-center">
                                <button class="btn btn-primary btn-block" type="submit">عضویت در وبسایت</button>
                            </div>

                        </form>

                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->

                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <p class="text-muted">حساب کاربری دارید؟ <a href="{{ route('login') }}" class="font-weight-medium ml-1">وارد شوید</a></p>
                    </div> <!-- end col -->
                </div>
                <!-- end row -->

            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    <!-- end container -->
</div>
<!-- end page -->

@component('components.copyright') @endcomponent

<div class="modal fade" id="RulesModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="model-title">قوانین و مقررات</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ config('rules') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
            </div>
        </div>
    </div>
</div>
@endsection