<?php

namespace App\Listeners\UserRegistered;

use App\Events\UserRegistered;
use App\Mail\UserActivationMail;
use App\User;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Mail;

class SendActivationEmail
{

    public $user;

    /**
     * Create the event listener.
     *
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Handle the event.
     *
     * @param  UserRegistered  $event
     * @return void
     */
    public function handle(UserRegistered $event)
    {
        if (config('must_verify_email')) {
            Mail::to($event->user->email)->send(new UserActivationMail($event->user, $event->verificationToken, $event->verificationId));
        }
    }
}
