<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>@yield('title') {{ config('site_title') }} </title>
    <!-- Bootstrap V4 -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-rtl.min.css') }}"/>
    <!-- Fonts -->
    <link rel="stylesheet" href="{{ asset('assets/css/icons.min.css') }}"/>
    <!-- Main Style -->
    <link rel="stylesheet" href="{{ asset('assets/css/land.min.css') }}"/>
</head>
<body class="rtl">
<header @if(isset($currentRouteName) and $currentRouteName == 'main') class="main-header" @endif>
    <div class="container">
        <nav class="navbar">
            @if(config('site_logo'))
                <h1><a href="{{ route('main') }}" class="navbar-brand">{{ config('site_logo') }}</a></h1>
            @elseif(config('site_logo_img') and !config('site_logo'))
                <a href="{{ route('main') }}" class="navbar-brand"><img src="{{ config('site_logo_img') }}" alt="Site Logo"></a>
            @else
                <a href="{{ route('main') }}" class="navbar-brand"><img src="{{ asset('assets/images/patronic-logo-light.png') }}" alt="Site Logo"></a>
            @endif
            @guest()
            <div class="navbar-left">
                <div id="headButtons" class="clearfix">
                    @if(Route::has('register'))
                    <a class="w-50 float-right p-1 text-center" href="{{ route('register') }}">عضویت</a>
                    @endif
                    <a class="w-50 float-left p-1 text-center rounded h-bg-black-50" href="{{ route('login') }}">ورود</a>
                </div>
                <div id="sendGuestTicketBtn" class="text-center m-3 d-none">
                    <a class="p-1" href="#">ارسال تیکت بدون عضویت</a>
                </div>
            </div>
            @endguest
            @auth
            <!-- Example split danger button -->
            <div class="btn-group">
                <button type="button" class="btn dropdown-btn" onclick="window.location.href='{{ route('panel.index') }}'">{{ auth()->user()->name }}</button>
                <button type="button" class="btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="sr-only">باز کردن منو</span>
                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{ route('panel.index') }}">پیشخوان</a>
                    <a class="dropdown-item" href="{{ route('panel.profile') }}">حساب کاربری</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="{{ route('panel.logout') }}">خروج</a>
                </div>
            </div>
            @endauth
        </nav>
        <nav class="mobile-navbar d-sm-none fixed-top">
            <a href="{{ config('site_url') }}" class="navbar-brand">
                <span>
                    @if(config('site_logo'))
                        <h4 class="logo-lg-text-light">{{ config('site_logo') }}</h4>
                    @else
                        <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                    @endif
                </span>
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mobileNavbar" aria-controls="mobileNavbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="fa fa-bars"></span>
            </button>
            <div class="collapse navbar-collapse" id="mobileNavbar">
                <ul class="navbar-nav mr-auto mt-2 mt-lg-0">
                    @auth
                        <li class="nav-item active">
                            <a class="nav-link" href="{{ route('panel.index') }}">پیشخوان</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('panel.profile') }}">حساب کاربری</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('panel.logout') }}">خروج</a>
                        </li>
                    @else
                        <li class="nav-item active">
                            <a class="nav-link" href="{{ route('login') }}">ورود</a>
                        </li>
                        @if(Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">عضویت</a>
                        </li>
                        @endif
                    @endauth
                </ul>
            </div>
        </nav>
        <div id="headerSearchSection" class="text-center mt-3 mb-5">
            <div id="howCanWeHelp">
                <h3>به بخش پشتیبانی خوش آمدید</h3>
                <p class="mt-3 mb-4">چطور میتوانیم کمکتان کنیم؟</p>
            </div>
            <div id="searchContainer">
                <form action="{{ route('home.search') }}" id="headSearchForm">
                    <input type="search" name="s" class="header-search-input" placeholder="به دنبال چه چیزی میگردید؟در مطالب سایت جستجو کنید..."/>
                    <button type="submit" class="header-search-sub-btn"><span class="fa fa-search"></span></button>
                </form>
            </div>
        </div>
        @if($templateConfigs['showOpenHoursSection'] ?? false and $currentRouteName ?? false)
        <div id="headerOpenTimes">
            <div class="text-center">
                <div class="text-center d-inline-block p-3">
                    <span class="far fa-calendar d-block mb-2"></span>
                    <small>{{ $templateConfigs['openDays'] }}</small>
                </div>
                <div class="text-center d-inline-block ml-3 p-3">
                    <span class="far fa-clock d-block mb-2"></span>
                    <small>{{ $templateConfigs['openHours'] }}</small>
                </div>
                <div class="text-center d-inline-block ml-3 p-3">
                    <span class="fa fa-tty d-block mb-2"></span>
                    <small>{{ $templateConfigs['phone'] }}</small>
                </div>
            </div>
        </div>
    </div>
    @endif
</header>

@yield('main')

<footer>
    <div>قدرت گرفته و پشتیبانی شده توسط <a href="https://patronic.ir">پاترونیک </a> - 1398</div>
</footer>
<script src="{{ asset('assets/js/jquery-3.4.1.min.js') }}"></script>
<script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery-innerfade.min.js') }}"></script>
<script src="{{ asset('assets/js/land.min.js') }}"></script>
</body>
</html>