@extends('layouts.user-panel.master')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">حساب کاربری</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">حساب کاربری</h4>
                        <p class="sub-header">اطلاعات حساب کاربری شما</p>
                    </div>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="card-body">
                    <form action="{{ route('panel.profile.update', $user) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label for="name" class="col-sm-2 col-form-label">نام و نام خانوادگی</label>
                            <div class="col-sm-10">
                                <input type="text" name="name" id="name" value="{{ $user->name }}" class="form-control @error('name') is-invalid @enderror" placeholder="نام و نام خانوادگی را وارد کنید" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="username" class="col-sm-2 col-form-label">نام کاربری</label>
                            <div class="col-sm-10">
                                <input type="text" size="20" maxlength="20" id="username" name="username" value="{{ $user->username }}" class="form-control @error('username') is-invalid @enderror" placeholder="مثال : ali_22">
                                @error('username')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <small class="form-text text-muted">حداکثر میتوانید 20 کارکتر وارد کنید.کارکترهای مجاز: حروف،اعداد،-،ـ </small>
                                    @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="mobile" class="col-sm-2 col-form-label">شماره موبایل
                                @if($user->mobile_verified_at)
                                    <small class="fa fa-check text-success" title="تایید شده" data-toggle="tooltip"></small>
                                @else
                                    <small class="fa fa-times text-danger" title="تایید نشده" data-toggle="tooltip"></small>
                                @endif
                            </label>
                            <div class="col-sm-10">
                                <input type="text" id="mobile" name="mobile"  value="{{ $user->mobile }}" class="form-control @error('mobile') is-invalid @enderror" placeholder="مثال: 09123456789" required>
                                @error('mobile')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-sm-2 col-form-label">ایمیل
                                @if($user->email_verified_at)
                                    <small class="fa fa-check text-success" title="تایید شده" data-toggle="tooltip"></small>
                                @else
                                    <small class="fa fa-times text-danger" title="تایید نشده" data-toggle="tooltip"></small>
                                @endif
                            </label>
                            <div class="col-sm-10">
                                <input type="email" id="email" name="email" value="{{ $user->email }}" class="form-control @error('email') is-invalid @enderror" placeholder="مثال : email@site.com" required>
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-sm-2 col-form-label">تصویر پروفایل</label>
                            <div class="col-sm-10">
                                <img class="rounded-circle mr-2" src="{{ $user->getFirstMediaUrl('avatar') ? url($user->getFirstMediaUrl('avatar')) : asset('assets/images/default-avatar.png') }}" width="33" alt="تصویر پروفایل">
                                <div class="fileupload btn btn-xs btn-secondary waves-effect mt-1">
                                    <span><i class="mdi mdi-cloud-upload mr-1"></i>انتخاب تصویر جدید</span>
                                    <input type="file" name="avatar" class="upload">
                                </div>
                                @error('avatar')
                                <span class="text-danger" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                        @if(config('ticket_signature') == 'both' or config('ticket_signature') == 'user')
                            <div class="form-group row">
                                <label for="signature" class="col-sm-2 col-form-label">امضا</label>
                                <div class="col-sm-10">
                                    <textarea name="signature" id="signature" class="form-control @error('signature') is-invalid @enderror" cols="30" rows="5" placeholder="متن امضای خود را وارد کنید...">{{ $user->signature }}</textarea>
                                    <small class="text-muted form-text">امضای شما در انتهای تیکت های شما نمایش داده خواهد شد</small>
                                    @error('signature')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        @endif
                        <div class="form-group clearfix mb-0">
                            <button type="submit" class="btn btn-success float-right">ذخیره حساب کاربری</button>
                        </div>
                    </form>
                </div>
            </div>
        </div><!-- end col -->
    </div>
    <!-- end row -->
@endsection