<?php $__env->startSection('content'); ?>

<div class="container mt-5">
    <div class="card">
        <div class="card-body">
            <div class="text-center mb-1 float-right">
                <a href="https://patronic.ir" class="text-muted" target="_blank">
                <img src="<?php echo e(asset('assets/images/patronic-logo-dark.png')); ?>" alt="سیستم پشتیبانی و ارسال تیکت پاترونیک" class="mb-1" height="35">
                <p>www.patronic.ir</p>
                </a>
            </div>
            <h3 class="card-title">مرحله اول نصب - بررسی پیش نیازها</h3>
            <p class="card-subtitle">بررسی پیش نیازهای مورد نیاز نصب</p>
            <hr>
            <div class="row">

                <?php echo $__env->make('layouts.setup.vertical-tabs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-9">
                    <div class="tab-content pt-0" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-server-requirement-tab">
                            <?php

                            $laravelVersion = '7.0';

                            $reqList = [
                                '7.0' => [
                                    'php' => '7.2.0',
                                    'mcrypt' => false,
                                    'openssl' => true,
                                    'pdo' => true,
                                    'mbstring' => true,
                                    'tokenizer' => true,
                                    'xml' => true,
                                    'ctype' => true,
                                    'json' => true,
                                    'bcmath' => true,
                                    'gettext' => true,
                                    'finfo' => true
                                ],
                            ];

                            $strOk = '<i class="fa fa-check"></i>';
                            $strFail = '<i class="fa fa-times"></i>';
                            $strUnknown = '<i class="fa fa-question"></i>';

                            $requirements = [];

                            // PHP Version
                            $requirements['php_version'] = version_compare(PHP_VERSION, $reqList[$laravelVersion]['php'], ">=");

                            // OpenSSL PHP Extension
                            $requirements['openssl_enabled'] = extension_loaded("openssl");

                            // PDO PHP Extension
                            $requirements['pdo_enabled'] = defined('PDO::ATTR_DRIVER_NAME');

                            // Mbstring PHP Extension
                            $requirements['mbstring_enabled'] = extension_loaded("mbstring");

                            // Tokenizer PHP Extension
                            $requirements['tokenizer_enabled'] = extension_loaded("tokenizer");

                            // XML PHP Extension
                            $requirements['xml_enabled'] = extension_loaded("xml");

                            // CTYPE PHP Extension
                            $requirements['ctype_enabled'] = extension_loaded("ctype");

                            // JSON PHP Extension
                            $requirements['json_enabled'] = extension_loaded("json");

                            // Mcrypt
                            //$requirements['mcrypt_enabled'] = extension_loaded("mcrypt_encrypt");

                            // BCMath
                            $requirements['bcmath_enabled'] = extension_loaded("bcmath");

                            // gettext
                            $requirements['gettext_enabled'] = extension_loaded("gettext");

                            // finfo
                            $requirements['finfo_enabled'] = extension_loaded("fileinfo");

                            // mod_rewrite

                            $pass = true;

                            foreach($requirements as $requirement => $val){
                                if(!$val){
                                    $pass = false;
                                    break;
                                }
                            }

                            ?>

                            <?php if($pass): ?>
                                <?php session(['step1_passed' => true]) ?>
                                <div class="alert alert-success"><strong>تبریک! </strong>سرور شما تمام پیش نیازهای نصب پاترونیک را دارا میباشد</div>
                            <?php else: ?>
                                <div class="alert alert-light border-right"><strong>نکته: </strong>سبز رنگ  بودن تمامی مستطیل ها به معنی سازگاری سرور شما برای نصب پاترونیک میباشد لذا برای ادامه مراحل نصب سبز بودن تمامی مستطیل ها الزامی میباشد</div>
                                <div class="alert alert-warning border-right"><strong>توجه: </strong>چنانچه یک یا چند مورد از مستطیل ها قرمز رنگ بودند متن داخل مستطیل های قرمز رنگ را برای پشتیبانی سرویس میزبانی خود ارسال کرده و درخواست فعالسازی موارد را بفرمایید</div>
                            <?php endif; ?>

                                <div class="wrapper">
                                <p class="alert <?php echo e($requirements['php_version'] ? 'alert-light text-success' : 'alert-danger'); ?>">
                                    <?php echo " " . ($requirements['php_version'] ? $strOk : $strFail); ?>
                                    PHP(<?php echo PHP_VERSION; ?>)
                                    <?php
                                    echo ">= " . $reqList[$laravelVersion]['php'];
                                    ?>


                                </p>

                                <?php if ($reqList[$laravelVersion]['openssl']) : ?>
                                <p class="alert <?php echo e($requirements['openssl_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['openssl_enabled'] ? $strOk : $strFail; ?> OpenSSL PHP Extension</p>
                                <?php endif; ?>

                                <?php if ($reqList[$laravelVersion]['pdo']) : ?>
                                <p class="alert <?php echo e($requirements['pdo_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['pdo_enabled'] ? $strOk : $strFail; ?> PDO PHP Extension</p>
                                <?php endif ?>

                                <?php if ($reqList[$laravelVersion]['mbstring']) : ?>
                                <p class="alert <?php echo e($requirements['mbstring_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['mbstring_enabled'] ? $strOk : $strFail; ?> Mbstring PHP Extension</p>
                                <?php endif ?>

                                <?php if ($reqList[$laravelVersion]['tokenizer']) : ?>
                                <p class="alert <?php echo e($requirements['tokenizer_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['tokenizer_enabled'] ? $strOk : $strFail; ?> Tokenizer PHP Extension</p>
                                <?php endif ?>


                                <?php if ($reqList[$laravelVersion]['xml']) : ?>
                                <p class="alert <?php echo e($requirements['xml_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['xml_enabled'] ? $strOk : $strFail; ?> XML PHP Extension</p>
                                <?php endif ?>

                                <?php if ($reqList[$laravelVersion]['ctype']) : ?>
                                <p class="alert <?php echo e($requirements['ctype_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['ctype_enabled'] ? $strOk : $strFail; ?> CTYPE PHP Extension</p>
                                <?php endif ?>

                                <?php if ($reqList[$laravelVersion]['json']) : ?>
                                <p class="alert <?php echo e($requirements['json_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['json_enabled'] ? $strOk : $strFail; ?>JSON PHP Extension</p>
                                <?php endif ?>

                                <?php if ($reqList[$laravelVersion]['mcrypt']) : ?>
                                <p class="alert <?php echo e($requirements['mcrypt_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['mcrypt_enabled'] ? $strOk : $strFail; ?> Mcrypt PHP Extension</p>
                                <?php endif ?>

                                <?php if (isset($reqList[$laravelVersion]['bcmath']) && $reqList[$laravelVersion]['bcmath']) : ?>
                                <p class="alert <?php echo e($requirements['bcmath_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['bcmath_enabled'] ? $strOk : $strFail; ?> BCmath PHP Extension</p>
                                <?php endif ?>

                                <?php if (isset($reqList[$laravelVersion]['finfo']) && $reqList[$laravelVersion]['finfo']) : ?>
                                <p class="alert <?php echo e($requirements['finfo_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['finfo_enabled'] ? $strOk : $strFail; ?> finfo PHP Extension</p>
                                <?php endif ?>

                                <?php if (isset($reqList[$laravelVersion]['gettext']) && $reqList[$laravelVersion]['gettext']) : ?>
                                <p class="alert <?php echo e($requirements['gettext_enabled'] ? 'alert-light text-success' : 'alert-danger'); ?>"><?php echo $requirements['gettext_enabled'] ? $strOk : $strFail; ?> gettext PHP Extension</p>
                                <?php endif ?>
                            </div>
                            <?php if($pass): ?>
                            <form action="<?php echo e(route('setup.handle', ['step' => 1])); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-primary float-right"><span>مرحله بعد</span><i class="mdi mdi-arrow-left align-text-top ml-1"></i></button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.setup.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/setup/step1.blade.php ENDPATH**/ ?>