<?php

namespace App;

use http\Env\Request;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Verification extends Model
{
    protected $guarded = [];

    public static function createEmailToken()
    {
        do {
            $token = Str::random(60);
            $checkToken = static::where(['type' => 'email','token' => $token])->get();
        } while (!$checkToken->isEmpty());

        return $token;
    }

    public static function createMobileToken()
    {
        do {
            $token = rand(100000, 999999);
            $checkToken = static::where(['type' => 'sms', 'token' => $token])->get();
        } while (!$checkToken->isEmpty());

        return $token;
    }
}
